% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmstanBig.R
\name{jmstanBig}
\alias{jmstanBig}
\title{Joint model for BIG data using rstanarm}
\usage{
jmstanBig(
  dtlong,
  dtsurv,
  longm,
  survm,
  samplesize = 50,
  time_var,
  id,
  nchain = 1,
  refresh = 2000
)
}
\arguments{
\item{dtlong}{longitudinal dataset, which contains id,visit time,longitudinal measurements along with various covariates}

\item{dtsurv}{survival dataset corresponding to the longitudinal dataset, with survival status and survival time}

\item{longm}{model for longitudinal response}

\item{survm}{survival model}

\item{samplesize}{sample size to divide the Big data}

\item{time_var}{time variable in longitudinal model, included in the longitudinal data}

\item{id}{name of id column in longitudinal dataset}

\item{nchain}{number of chain for MCMC}

\item{refresh}{refresh rate for MCMC chain}
}
\value{
returns a list containing various output which are useful for prediction.
}
\description{
function for joint model in BIG DATA using \link{rstanarm} package
}
\examples{

 \donttest{
##
library(survival)
library(dplyr)
fit3<-jmstanBig(dtlong=long2,dtsurv = surv2,longm=y~ x7+visit+(1|id),
survm=Surv(time,status)~x1+visit,samplesize=200,time_var='visit',id='id')
P2<-postTraj(model<-fit3,m<-1,ids<-c(1,2,100))
pp1<-plot(P2$p1[[1]],plot_observed = TRUE)
pp2<-plot(P2$p1[[2]],plot_observed = TRUE)
pp3<-plot(P2$p1[[3]],plot_observed = TRUE)
##
}

}
\references{
Goodrich, B., et al. "rstanarm: Bayesian applied regression modeling via Stan. R package version 2.17. 4." Online< http://mc-stan. org (2018).
}
\seealso{
\link{jmbayesBig},\link{jmcsBig},\link{joinRMLBig}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
