% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annuity.R
\name{annuity}
\alias{annuity}
\alias{annuity.pv}
\alias{annuity.fv}
\alias{annuity.instalment}
\alias{annuity.periods}
\alias{annuity.rate}
\alias{annuity.instalment.breakup}
\title{Present Value of Annuity and Related Functions}
\usage{
annuity.pv(rate, n.periods = Inf, instalment = 1,
  terminal.payment = 0, immediate.start = FALSE, cf.freq = 1,
  comp.freq = 1)

annuity.fv(rate, n.periods = Inf, instalment = 1,
  terminal.payment = 0, immediate.start = FALSE, cf.freq = 1,
  comp.freq = 1)

annuity.instalment(rate, n.periods = Inf, pv = if (missing(fv)) 1 else
  0, fv = 0, terminal.payment = 0, immediate.start = FALSE,
  cf.freq = 1, comp.freq = 1)

annuity.periods(rate, instalment = 1, pv = if (missing(fv)) 1 else 0,
  fv = 0, terminal.payment = 0, immediate.start = FALSE,
  cf.freq = 1, comp.freq = 1, round2int.digits = 3)

annuity.rate(n.periods = Inf, instalment = 1, pv = if (missing(fv)) 1
  else 0, fv = 0, terminal.payment = 0, immediate.start = FALSE,
  cf.freq = 1, comp.freq = 1)

annuity.instalment.breakup(rate, n.periods = Inf, pv = 1,
  immediate.start = FALSE, cf.freq = 1, comp.freq = 1,
  period.no = 1)
}
\arguments{
\item{rate}{The interest rate in decimal (0.10 or 10e-2 for 10\%)}

\item{n.periods}{The number of periods in the annuity.}

\item{instalment}{The instalment (cash flow) per period.}

\item{terminal.payment}{Any cash flow at the end of the annuity. For
example, a bullet repayment at maturity of the unamortized principal.}

\item{immediate.start}{Logical variable which is \code{TRUE} for immediate
annuities (the first instalment is due immediately) and \code{FALSE} for deferred
annuities (the first instalment is due at the end of the first period).}

\item{cf.freq}{Frequency of annuity payments: 1 for annual, 2 for
semi-annual, 12 for monthly.}

\item{comp.freq}{Frequency of compounding of interest rates: 1 for annual,
2 for semi-annual, 12 for monthly, Inf for continuous compounding.}

\item{pv}{The present value of all the cash flows including the terminal
payment.}

\item{fv}{The future value (at the end of the annuity) of all the cash
flows including the terminal payment.}

\item{round2int.digits}{Used only in \code{annuity.periods}. If the computed
number of periods is an integer when rounded to round2int.digits, then the
rounded integer value is returned. With the default value of 3, 9.9996 is
returned as 10, but 9.9994 and 9.39999999 are returned without any
rounding.}

\item{period.no}{Used only in \code{annuity.instalment.breakup}. This is the
period for which the instalment needs to be broken up into principal and
interest parts.}
}
\value{
For most functions, the return value is one of the arguments
described above. For example \code{annuity.pv} returns \code{pv}. The only exception is
\code{annuity.instalment.breakup}. This returns a list with the following
components:
\item{opening.principal}{The principal balance at the beginning
of the period}
\item{closing.principal}{The principal balance at the end of
the period}
\item{interest.part}{The portion of the instalment which
represents interest}
\item{principal.part}{The portion of the instalment
which represents principal repayment}
}
\description{
Functions to compute present value and future value of annuities, to find
instalment given the present value or future value. Can also find the rate
or the number of periods given other parameters.
}
\details{
These functions are based on the Present Value relationship:
\deqn{pv = fv \cdot df = 
terminal.payment \cdot df + \frac{instalment (1 - df)}{r}}{pv = fv * df = 
terminal.payment * df + instalment * (1 - df) / r}
where
\eqn{df = (1 + r)^{-n.periods}} is the \eqn{n.periods} discount factor and
\eqn{r} is the per period interest rate computed using
rate, cf.freq and comp.freq.

It is intended that only one of \eqn{pv} or \eqn{fv} is used in any function call, but
internally the functions use \eqn{pv + fv \cdot df}{pv + fv * df} as the
LHS of the present value relationship under the assumption that only of the
two is non zero.

The function \code{annuity.instalment.breakup} regards the annuity as a repayment
of a loan equal to \code{pv} plus the present value of terminal.payment. The
instalment paid in period period.no is broken up into the principal
repayment (amortization) and interest components.
}
\author{
Prof. Jayanth R. Varma \email{jrvarma@iima.ac.in}
}
