% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCorr.R
\name{runCorr}
\alias{runCorr}
\title{Running Correlations}
\usage{
runCorr(data, wsize = 25)
}
\arguments{
\item{data}{\emph{N} x \emph{v} dataframe where \emph{N} is the no. of time points and \emph{v} the no. of variables}

\item{wsize}{window size}
}
\value{
Running correlationa time series
}
\description{
Extracts the running correlations by sliding a window comprised of \code{wsize} time points, and in each window,
the correlation of each pair of variables is computed.
Each time the window is slid, the oldest time point is discarded and the latest time point is added.
}
\examples{
data(MentalLoad)
RS<-runCorr(data=MentalLoad,wsize=25)
ts.plot(RS, gpars=list(xlab="Window", ylab="Correlations", col=1:3,lwd=2))
}
