% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{nmse}
\alias{nmse}
\title{NMSE (Normalized Mean Squared Error)}
\usage{
nmse(target, pred)
}
\arguments{
\item{target}{Numeric vector containing the actual values.}

\item{pred}{Numeric vector containing the predicted values.
(The order should be the same than in the target)}
}
\value{
The normalized mean squared error (a single value).
}
\description{
`nmse()` computes the Normalized Mean Squared Error between the output
of a regression model and the actual values of the target.
}
\details{
The Normalized Mean Squared error is defined as:

\deqn{NMSE=MSE/((N-1)*var(target))}

where MSE is the Mean Squared Error.
}
\examples{
y <- 1:10
y_pred <- y+rnorm(10)
nmse(y,y_pred)
}
