% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_test_pairwise.R
\name{chi_square_test_pairwise}
\alias{chi_square_test_pairwise}
\title{Chi square test, pairwise}
\usage{
chi_square_test_pairwise(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  focal_dv_value = NULL,
  percentages_only = NULL,
  counts_only = NULL,
  sigfigs = 3,
  chi_sq_test_stats = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable
(must be a categorical variable)}

\item{dv_name}{name of the dependent variable (must be a binary variable)}

\item{focal_dv_value}{focal value of the dependent variable
whose frequencies will be calculated (i.e., the value of the
dependent variable that will be considered a "success" or
a result of interest)}

\item{percentages_only}{tabulate percentages of the focal DV value only}

\item{counts_only}{tabulate counts of the focal DV value only}

\item{sigfigs}{number of significant digits to round to}

\item{chi_sq_test_stats}{if \code{chi_sq_test_stats = TRUE},
chi-square test statistic and degrees of freedom will be included
in the pairwise comparison data.table.}
}
\description{
Conducts a chi-square test for every possible pairwise comparison
with Bonferroni correction
}
\examples{
chi_square_test_pairwise(data = mtcars, iv_name = "vs", dv_name = "am")
chi_square_test_pairwise(data = mtcars, iv_name = "vs", dv_name = "am",
percentages_only = TRUE)
}
