% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_var_names.R
\name{change_var_names}
\alias{change_var_names}
\title{Change variable names in a data set}
\usage{
change_var_names(
  data = NULL,
  old_var_names = NULL,
  new_var_names = NULL,
  skip_absent = FALSE,
  print_summary = TRUE,
  output_type = "dt"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{old_var_names}{a vector of old variable names
(i.e., variable names to change)}

\item{new_var_names}{a vector of new variable names}

\item{skip_absent}{If \code{skip_absent = TRUE}, old variable names
that do not exist in the data set will be skipped (default = TRUE).}

\item{print_summary}{If \code{print_summary = TRUE}, a summary of
old and new variable names will printed. (default = TRUE)}

\item{output_type}{type of the output. If \code{output_type = "dt"},
the function's output will be a data.table with changed names.
If \code{output_type = "summary"}, the function's output will
be a data.table listing old and new variable names.
By default, \code{output_type = "dt"}.}
}
\value{
a data.table object with changed variable names
}
\description{
Change variable names in a data set
}
\examples{
change_var_names(
mtcars, old = c("mpg", "cyl"), new = c("mpg_new", "cyl_new"))
}
