% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_scale_items.R
\name{score_scale_items}
\alias{score_scale_items}
\title{Score scale items}
\usage{
score_scale_items(
  items = NULL,
  reverse = NULL,
  operation = "mean",
  na_summary = TRUE,
  reverse_code_minuend = NULL
)
}
\arguments{
\item{items}{list of scale items (i.e., list of vectors of ratings)
to code normally (as opposed to reverse coding).}

\item{reverse}{list of scale items to reverse code.}

\item{operation}{if \code{operation = "mean"}, mean of the scale items
will be calculated; if \code{operation = "sum"}, sum of the scale items
will be calculated (default = "mean").}

\item{na_summary}{logical. If \code{na_summary = TRUE} a summary of
NA values will be printed; if \code{na_summary = FALSE} the summary
will not be printed (default = TRUE).}

\item{reverse_code_minuend}{required for reverse coding; the number
from which to subtract item ratings when reverse-coding. For example,
if the items to reverse code are measured on a 7-point scale, enter
\code{reverse_code_minuend = 8}.}
}
\description{
Score items in a scale (e.g., Likert scale items) by computing the
sum or mean of the items.
}
\examples{
score_scale_items(items = list(1:5, rep(3, 5)),
reverse = list(rep(5, 5)), reverse_code_minuend = 6)
score_scale_items(items = list(c(1, 1), c(1, 5)),
reverse = list(c(5, 3)), reverse_code_minuend = 6, na_summary = FALSE)
score_scale_items(items = list(c(1, 1), c(1, 5)),
reverse = list(c(5, 1)), reverse_code_minuend = 6, operation = "sum")
}
