% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio.R
\name{odds_ratio}
\alias{odds_ratio}
\title{Odds ratio}
\usage{
odds_ratio(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  contingency_table = NULL,
  ci = 0.95,
  round_ci_limits = 2,
  invert = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable (grouping variable)}

\item{dv_name}{name of the dependent variable (binary outcome)}

\item{contingency_table}{a contingency table, which can be directly
entered as an input for calculating the odds ratio}

\item{ci}{width of the confidence interval. Input can be any value
less than 1 and greater than or equal to 0. By default, \code{ci = 0.95}.
If \code{ci = TRUE}, the default value of 0.95 will be used. If \code{
ci = FALSE}, no confidence interval will be estimated.}

\item{round_ci_limits}{number of decimal places to which to
round the limits of the confidence interval (default = 2)}

\item{invert}{logical. Whether the inverse of the odds ratio
(i.e., 1 / odds ratio) should be returned.}
}
\description{
Calculate odds ratio, as illustrated in Borenstein et al.
(2009, pp. 33-36, ISBN: 978-0-470-05724-7)
}
\examples{
\dontrun{
odds_ratio(data = mtcars, iv_name = "vs", dv_name = "am")
odds_ratio(data = mtcars, iv_name = "vs", dv_name = "am", ci = 0.9)
odds_ratio(contingency_table = matrix(c(5, 10, 95, 90), nrow = 2))
odds_ratio(contingency_table = matrix(c(5, 10, 95, 90), nrow = 2),
invert = TRUE)
odds_ratio(contingency_table = matrix(c(34, 39, 16, 11), nrow = 2))
}
}
