% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlookup.R
\name{vlookup}
\alias{vlookup}
\title{Vlookup}
\usage{
vlookup(
  lookup_values = NULL,
  reference_dt = NULL,
  col_name_for_lookup_values = NULL,
  col_name_for_output_values = NULL
)
}
\arguments{
\item{lookup_values}{a vector of values to look up}

\item{reference_dt}{a data.table containing the values to look up
as well as values associated with the looked-up values
that need to be returned.}

\item{col_name_for_lookup_values}{in the reference data.table,
name of the column containing \code{lookup_values}.}

\item{col_name_for_output_values}{in the reference data.table,
name of the column containing values to return (i.e., values
associated with the looked-up values that will be the function's output)}
}
\description{
Look up values in a reference data.table and return values
associated with the looked-up values contained in the reference data.table
}
\examples{
vlookup(lookup_values = c(2.620, 2.875), reference_dt = mtcars[1:9, ],
col_name_for_lookup_values = "wt", col_name_for_output_values = "qsec")
}
