% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{pivot_table}
\alias{pivot_table}
\title{Pivot Table}
\usage{
pivot_table(
  data = NULL,
  row_names = NULL,
  col_names = NULL,
  function_as_character = NULL,
  sigfigs = 3,
  output = "dt",
  remove_col_names = TRUE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{row_names}{names of variables for constructing rows}

\item{col_names}{names of variables for constructing columns
independent variables}

\item{function_as_character}{function to perform for each cell in
the pivot table}

\item{sigfigs}{number of significant digits to which to round
values in the pivot table (default = 3)}

\item{output}{type of output. If \code{output = "dt"}, the function's
output will be a pivot table in a data.table format.
If \code{output = "subsets"}, the function's output will be a list of
data tables that are subsets representing each cell in the pivot table.
By default, \code{output = "dt"}}

\item{remove_col_names}{logical. Should the column names
(i.e., v1, v2, ...) be removed in the data table output?}
}
\value{
the output will be a contingency table in a data.table format
}
\description{
Create a pivot table.
}
\examples{
pivot_table(
  data = mtcars, col_names = "am", row_names = c("cyl", "vs"),
  function_as_character = "mean(mpg)")
pivot_table(
  data = mtcars, col_names = "am", row_names = c("cyl", "vs"),
  function_as_character = "sum(mpg < 17)")
pivot_table(
  data = mtcars, col_names = "am", row_names = c("cyl", "vs"),
  function_as_character =
  "round(sum(mpg < 17) / sum(!is.na(mpg)) * 100, 0)")
}
