% Generated by roxygen2 (4.0.1): do not edit by hand
\name{citet}
\alias{citet}
\title{Add a textual citation}
\usage{
citet(x, cito = NULL, ..., citation_format = getOption("citation_format",
  "compatibility"))
}
\arguments{
\item{x}{a doi or list of dois, or a bibentry (or list of bibentries)}

\item{cito}{Semantic reason for the citation. Only active if linked=TRUE}

\item{...}{additional arguments (dependent on citation_format).}

\item{citation_format}{name of the citation format to use.  Currently
available options are "pandoc" or "compatibility".}
}
\value{
a text inline citation
}
\description{
Parameters listed here are the same for parenthetical
 citation, \code{\link{citep}}.
}
\details{
Stores the full citation in a "works_cited" list,
which can be printed with \code{\link{bibliography}}.
A variety of reasons for the citation can be provided following the
CiTO ontology:
c("cites","citesAsAuthority", "citesAsMetadataDocument",
  "citesAsSourceDocument","citesForInformation",
  "isCitedBy","obtainsBackgroundFrom", "sharesAuthorsWith", "usesDataFrom",
  "usesMethodIn", "confirms", "credits", "extends", "obtainsSupportFrom",
  "supports", "updates", "corrects", "critiques", "disagreesWith",
  "qualifies", "refutes", "discusses", "reviews")
}
\examples{
\donttest{
library(knitcitations)
 citet("10.3998/3336451.0009.101")
 ## Read in the bibtex information for some packages:
 knitr <- citation("knitr")
 citet(knitr)
 # generate the full bibliography:
 bibliography()
## Assign a citation key to a doi and then use it later:
citet(c(Halpern2006="10.1111/j.1461-0248.2005.00827.x"))
citet("Halpern2006")
}
}

