% Writing beautiful and reproducible slides quickly
% Yihui Xie
% 2012/04/30




# Why

- after you finished typing `\documentclass{beamer}` and `\title{}`, I have finished my first slide with markdown
- much less commands to remember, e.g. to write bullet points, just begin with a dash "`-`" instead of `\begin{itemize}` and `\item`; how things can be simpler?
- I know you want math to show you are a statistician, e.g. $f(k)={n \choose k}p^{k}(1-p)^{n-k}$
- you do not need to maintain output -- only maintain a source file
- HTML5/CSS3 is much more fun than LaTeX

# A bit R code



```r
head(cars)
```



```
##   speed dist
## 1     4    2
## 2     4   10
## 3     7    4
## 4     7   22
## 5     8   16
## 6     9   10
```



```r
cor(cars)
```



```
##        speed   dist
## speed 1.0000 0.8069
## dist  0.8069 1.0000
```




# Graphics too



```r
library(ggplot2)
qplot(speed, dist, data = cars) + geom_smooth()
```

![A scatterplot of `cars`](http://i.imgur.com/hAAlT.png) 


# How

- source editor: [RStudio](http://www.rstudio.org/) (perfect integration with [**knitr**](http://yihui.name/knitr/); one-click compilation); currently you have to use the [preview version](http://www.rstudio.org/download/preview) (>= 0.96.109)
- HTML5 slides converter: [pandoc](http://johnmacfarlane.net/pandoc/); this document was generated by: `pandoc -s -S -i -t dzslides --mathjax knitr-slides.md -o knitr-slides.html`
- the file [`knitr-slides.md`](https://github.com/yihui/knitr/blob/master/inst/examples/knitr-slides.md) is the markdown output from its [source](https://github.com/yihui/knitr/blob/master/inst/examples/knitr-slides.Rmd): `library(knitr); knitr('knitr-slides.Rmd')`
- or simple click the button `Knit HTML` in RStudio

# For ninjas

- you should tweak the default style; why not try some [Google web fonts](http://www.google.com/webfonts)? (think how painful it is to wrestle with fonts in LaTeX)
- pandoc provides 3 types of HTML5 slides (dzslides is one of them)
- you can tweak the default template to get better appearances
- if you have come up with a better dzslides template, please let me know or contribute to pandoc directly (e.g. `pre` blocks should have `max-width` and `max-height`)

# For beamer lovers

- pandoc supports conversion to beamer as well. period.

# For Powerpoint lovers

- ...

# Reproducible research

It is good to include the session info, e.g. this document is produced with **knitr** version `0.6`. Here is my session info:



```r
print(sessionInfo(), locale = FALSE)
```



```
## R version 2.15.0 (2012-03-30)
## Platform: x86_64-pc-linux-gnu (64-bit)
## 
## attached base packages:
## [1] methods   stats     graphics  grDevices utils     datasets  base     
## 
## other attached packages:
## [1] ggplot2_0.9.1 knitr_0.5.6  
## 
## loaded via a namespace (and not attached):
##  [1] codetools_0.2-8    colorspace_1.1-1   dichromat_1.2-4   
##  [4] digest_0.5.2       evaluate_0.4.2     formatR_0.4.1     
##  [7] grid_2.15.0        highlight_0.3.1    labeling_0.1      
## [10] MASS_7.3-18        memoise_0.1        munsell_0.3       
## [13] parser_0.0-14      plyr_1.7.1         proto_0.3-9.2     
## [16] RColorBrewer_1.0-5 Rcpp_0.9.10        RCurl_1.91-1      
## [19] reshape2_1.2.1     scales_0.2.1       stringr_0.6       
## [22] tools_2.15.0       XML_3.6-2         
```




# Life is short

- so keep your audience awake!

    ![](http://i.imgur.com/qBO9K.jpg)
