% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_filterByClass.R,
%   R/01_class_90_deprecated_classes.R, R/02_method_pasteText.R,
%   R/02_method_readTagged.R, R/02_method_textTransform.R
\docType{class}
\name{koRpus-deprecated}
\alias{koRpus-deprecated}
\alias{kRp.filter.wclass}
\alias{kRp_tagged}
\alias{kRp.tagged-class}
\alias{kRp_txt_freq}
\alias{kRp.txt.freq-class}
\alias{kRp_txt_trans}
\alias{kRp.txt.trans-class}
\alias{kRp_analysis}
\alias{kRp.analysis-class}
\alias{kRp.text.paste}
\alias{read.tagged}
\alias{kRp.text.transform}
\title{Deprecated object classes}
\usage{
kRp.filter.wclass(...)

kRp.text.paste(...)

read.tagged(...)

kRp.text.transform(...)
}
\arguments{
\item{...}{Parameters to be passed to the replacement of the function}
}
\description{
These classes are no longer used by the \code{koRpus} package and will be removed in a later version.
They are kept here for the time being so you can still load old objects and convert them into new objects using the
\code{fixObject} method.

These functions will be removed soon and should no longer ne used.
}
\section{Slots}{

\describe{
\item{\code{lang}}{A character string,
      naming the language that is assumed for the tokenized text in this object.}

\item{\code{desc}}{Descriptive statistics of the tagged text.}

\item{\code{TT.res}}{Results of the called tokenizer and POS tagger. The data.frame usually has eleven columns:
\describe{
  \item{\code{doc_id}:}{Factor, optional document identifier.}
  \item{\code{token}:}{Character, the tokenized text.}
  \item{\code{tag}:}{Factor, POS tags for each token.}
  \item{\code{lemma}:}{Character, lemma for each token.}
  \item{\code{lttr}:}{Integer, number of letters.}
  \item{\code{wclass}:}{Factor, word class.}
  \item{\code{desc}:}{Factor, a short description of the POS tag.}
  \item{\code{stop}:}{Logical, \code{TRUE} if token is a stopword.}
  \item{\code{stem}:}{Character, stemmed token.}
  \item{\code{idx}:}{Integer, index number of token in this document.}
  \item{\code{sntc}:}{Integer, number of sentence in this document.}
}
This data.frame structure adheres to the "Text Interchange Formats" guidelines set out by rOpenSci[1].}

\item{\code{freq.analysis}}{A list with information on the word frequencies of the analyzed text.}

\item{\code{diff}}{A list with mostly atomic vectors,
      describing the amount of diffences between both text variants (percentage):
\describe{
  \item{\code{all.tokens}:}{Percentage of all tokens, including punctuation,
      that were altered.}
  \item{\code{words}:}{Percentage of altered words only.}
  \item{\code{all.chars}:}{Percentage of all characters, including punctuation,
      that were altered.}
  \item{\code{letters}:}{Percentage of altered letters in words only.}
  \item{\code{transfmt}:}{Character vector documenting the transformation(s) done to the tokens.}
  \item{\code{transfmt.equal}:}{Data frame documenting which token was changed in which transformational step. Only available if more than one transformation was done.}
  \item{\code{transfmt.normalize}:}{A list documenting steps of normalization that were done to the object,
      one element per transformation.
    Each entry holds the name of the method, the query parameters,
      and the effective replacement value.}
}}

\item{\code{lex.div}}{Information on lexical diversity}
}}

\section{S4 Class \code{kRp.tagged}}{

This was used for objects returned by \code{\link[koRpus:treetag]{treetag}} or \code{\link[koRpus:tokenize]{tokenize}}.
It was replaced by \code{\link[koRpus:kRp.text-class]{kRp.text}}.
}

\section{S4 Class \code{kRp.txt.freq}}{

This was used for objects returned by \code{\link[koRpus:freq.analysis]{freq.analysis}}.
It was replaced by \code{\link[koRpus:kRp.text-class]{kRp.text}}.
}

\section{S4 Class \code{kRp.txt.trans}}{

This was used for objects returned by \code{\link[koRpus:textTransform]{textTransform}},
      \code{\link[koRpus:clozeDelete]{clozeDelete}},
\code{\link[koRpus:cTest]{cTest}}, and \code{\link[koRpus:jumbleWords]{jumbleWords}}.
It was replaced by \code{\link[koRpus:kRp.text-class]{kRp.text}}.
}

\section{S4 Class \code{kRp.analysis}}{

This was used for objects returned by \code{kRp.text.analysis}.
The function is also deprecated,
      functionality can be replicated by combining \code{treetag},\code{freq.analysis} and \code{lex.div}.
}

\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
\keyword{classes}
