% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixationFilterFunctions.R
\name{algorithm_adaptive}
\alias{algorithm_adaptive}
\title{Adaptive velocity-based algorithm for saccade and fixation detection}
\usage{
algorithm_adaptive(
  gaze,
  min.fixation.duration = 40,
  min.saccade.duration = 10,
  xcol = "x.raw",
  ycol = "y.raw",
  save.velocity.profiles = FALSE,
  missing.samples.threshold = 0.5,
  merge.ms.threshold = 75,
  distance.threshold = 0.7,
  alpha = 0.7,
  beta = 0.3,
  one_degree = 40,
  velocity.filter.ms = 10,
  peak.threshold.start = 200,
  onset.threshold.sd = 3,
  min.period.ms = 40,
  margin.ms = 3,
  trim.fixations = TRUE,
  trim.dispersion.threshold = NA
)
}
\arguments{
\item{gaze}{Data frame with gaze data before saccade and fixation data identification. The data frame must include the variable timestamp with
timing in milliseconds and columns for x and y coordinates specified by the columns 'xcol' and 'ycol' respectively.}

\item{min.fixation.duration}{Minimum duration of accepted fixations. This parameter is also used to calculate 'local noise' prior to the onset of a saccade. Default: 40}

\item{min.saccade.duration}{Minimum duration of accepted saccades in ms. Default: 10}

\item{xcol}{column in the gaze data frame where x coordinates are found. Default: x.raw}

\item{ycol}{column in the gaze data frame where y coordinates are found. Default: y.raw}

\item{save.velocity.profiles}{If TRUE, save velocity profiles of each saccade. Default: FALSE.}

\item{missing.samples.threshold}{Remove fixations with a higher proportion of missing samples. Range 0 to 1.}

\item{merge.ms.threshold}{Subsequent fixations occuring within this time window and distance specified by distance.threshold are merged. Set to 0 if you don't want to merge fixations.}

\item{distance.threshold}{Subsequent fixations occurring withing this distance are merged. Set to 0 if you don't want to merge fixations.}

\item{alpha}{Weight of the saccade onset threshold when defining threshold for saccade offset}

\item{beta}{Weight of local noise factor when defining threshold for saccade offset}

\item{one_degree}{one degree of the visual field in the unit of the x and y coordinates in the data. Typically pixels or degrees.}

\item{velocity.filter.ms}{If velocity.filter.ms is not NA, the velocity vector is smoothed using a moving median filter corresponding to this value in ms
before the propose threshold is identified. Default: 10.}

\item{peak.threshold.start}{Initial peak threshold value in degrees of the visual field. Default: 200}

\item{onset.threshold.sd}{Number of standard deviations used to define saccade onset threshold}

\item{min.period.ms}{Peak velocity threshold will be iteratively updated based on periods in the data in which consecutive values of at least this time period are below the previous threshold estimate.}

\item{margin.ms}{A margin in ms around periods of identified consecutive values below the previous threshold estimate which will be excluded from the estimates. This makes
the algorithm more robust to noise.}

\item{trim.fixations}{If TRUE, the onset of each fixation will be shifted forwards to the first non-missing (non-NA) sample during the period. The offset will be shifted backwards to the last non-missing
sample. If TRUE, and the parameter trim.dispersion.threshold is a positive number, samples at the margins with large distances from the centroid will also be excluded}

\item{trim.dispersion.threshold}{If not NA and trim.fixations is TRUE, fixation onsets and offests will also be shrinked to exclude any samples at the margins with a larger
distance from the fixation centroid than trim.dispersion.threshold * MAD.}
}
\value{
list including separate data frames for fixations, saccades, and sample-by-sample data
}
\description{
The function is based on a procedure suggested by Nyström and Holmqvist 2010. Behavior Research Methods, 42, 188-204.
Velocity thresholds for saccade onset and offset are adapted to the specific data at hand.
Please see Nyström and Holmqvist (2010) for a description of this procedure.
STEP 1: The function starts by identifying peak velocities larger than an initial threshold (peak threshold, specified by the parameter peak.threshold.start),
and then iteratively adjusts this threshold through the following steps: A) The mean (M) and standard deviation (SD) of the velocities of all samples
with velocties below the peak threshold are calculated. B) the updated peak threshold is defined as M +6SD. C) Steps A-B are repeated until
the difference between the old and new peak threshold is < 1 degree. D) The threshold for identification of saccade onsets (saccade onset threshold) is defined as M + onset.threshold *SD.
For each segment in the data with velocities above peak threshold, go through steps 2-3:

STEP 2: Saccade onset is defined by searching backwards from the leftmost sample with velocity above peak threshold to the first sample with a velocity above saccade onset threshold and a higher velocity than the previous sample.
STEP 3: Define saccade offset threshold as a weighted sum of a) the saccade onset threshold and b) the 'local noise factor' defined as mean + 3SD of sample-to-sample velocity during a period just before saccade onset. This period has the same length as
the minimum fixation duration (specified by the parameter min.fixation.duration)
Saccade onset is defined by searching forward from the rightmost sample with a velocity above peak threshold to the first sample with a velocity below saccade offset threshold and a lower velocity than the previous sample.
STEP 4: Fixations are defined as periods between saccades (as in the \code{I-VT} algorithm)

If the function can not detect a sample which fulfills both the threshold criterion and the acceleration/deceleration criterion during step 2-3, it will try to find a sample that fulfills the threshold criterion. If this fails, the saccade is discarded.

The input data should be pre-processed (e.g., noise removal and interpolation over gaps)

The output data is a list with three data frames: fixations includes all detected fixations with coordinates, duration
and a number of other metrics, saccades includes data for saccades, filt.gaze is a sample-by-sample data frame with time stamps, and gaze coordinates before ("raw") and after fixation detection.
The function has a number of parameters for removing potentially invalid fixations and saccades. The parameter min.fixation.duration can be used to remove unlikely
short fixations. If the parameter missing.samples threshold is set to a value lower than 1, fixations with a higher proportion of missing raw samples are removed.
}
