% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l0ara.R
\name{l0ara}
\alias{l0ara}
\title{fit a generalized linear model with l0 penalty}
\usage{
l0ara(x, y, family, lam, maxit, eps)
}
\arguments{
\item{x}{Input matrix, of dimension nobs x nvars; each row is an observation vector.}

\item{y}{Response variable. Quantitative for \code{family="gaussian"}; positive quantitative for \code{family="gamma"} or \code{family="inv.gaussian"} ; a factor with two levels for \code{family="logit"}; non-negative counts for \code{family="poisson"}.}

\item{family}{Response type(see above).}

\item{lam}{A user supplied \code{lambda} value. Try use \code{cv.l0ara} first to select optimal tunning and then refit with \code{lam.min}.}

\item{maxit}{Maximum number of passes over the data for \code{lambda}. Default value is \code{1e3}.}

\item{eps}{Convergence threshold. Default value is \code{1e-4}.}
}
\value{
An object with S3 class "l0ara" containing:
 \item{beta}{A vector of coefficients}
 \item{df}{Number of nonzero coefficients}
 \item{iter}{Number of iterations}
 \item{lambda}{The lambda used}
 \item{x}{Design matrix}
 \item{y}{Response variable}
}
\description{
An adaptive ridge algorithm for feature selection with L0 penalty.
}
\details{
The sequence of models indexed by the parameter lambda is fit using adptive ridge algorithm. The objective function for generalized linear models (including \code{family} above) is defined to be \deqn{-(log likelihood)+(\lambda/2)*|\beta|_0} This adaptive ridge algorithm is developed to approximate L0 penalized generalized linear models with sequential optimization and is efficient for high-dimensional data.
}
\examples{
# Linear regression
# Generate design matrix and response variable
n <- 100
p <- 40
x <- matrix(rnorm(n*p), n, p)
beta <- c(1,0,2,3,rep(0,p-4))
noise <- rnorm(n)
y <- x\%*\%beta+noise
# fit sparse linear regression
res.gaussian <- l0ara(x, y, family="gaussian", 1)

# predict for new observations
print(res.gaussian)
predict(res.gaussian, newx=matrix(rnorm(3,p),3,p))
coef(res.gaussian)

# Logistic regression
# Generate design matrix and response variable
n <- 100
p <- 40
x <- matrix(rnorm(n*p), n, p)
beta <- c(1,0,2,3,rep(0,p-4))
prob <- exp(x\%*\%beta)/(1+exp(x\%*\%beta))
y <- rbinom(n, rep(1,n), prob)
# fit sparse logistic regression
res.logit <- l0ara(x, y, family="logit", 0.7)

# predict for new observations
print(res.logit)
predict(res.logit, newx=matrix(rnorm(3,p),3,p))
coef(res.logit)

# Poisson regression
# Generate design matrix and response variable
n <- 100
p <- 40
x <- matrix(rnorm(n*p), n, p)
beta <- c(1,0,0.5,0.3,rep(0,p-4))
mu <- exp(x\%*\%beta)
y <- rpois(n, mu)
# fit sparse Poisson regression
res.pois <- l0ara(x, y, family="poisson", 0.7)

# predict for new observations
print(res.pois)
predict(res.pois, newx=matrix(rnorm(3,p),3,p))
coef(res.pois)
}
\author{
Wenchuan Guo <wguo007@ucr.edu>, Zhenqiu Liu <Zhenqiu.Liu@cshs.org>
}
\seealso{
\code{cv.l0ara}, \code{predict}, \code{coef} methods.
}

