% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeMajorAxisLength.R
\encoding{UTF-8}
\name{lakeMajorAxisLength}
\alias{lakeMajorAxisLength}
\title{Calculate the length of the major axis for lake}
\usage{
lakeMajorAxisLength(inLakeMorpho, addLine = TRUE)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the 
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{addLine}{Boolean to determine if the selected major axis line should be 
added to the inLakeMorpho object.  Defaults to True}
}
\value{
This returns a numeric value indicating the length of the major axis
 in the lake. Units are the same as the input data.
}
\description{
Major axis length is defined as the maximum length spanning the convex hull
of a lake.
}
\examples{
data(lakes)
lakeMajorAxisLength(inputLM)
plot(inputLM$lake)
lines(inputLM$majoraxisLengthLine)
}
\references{
\href{https://en.wikipedia.org/wiki/Semi-major_and_semi-minor_axes}{Wikipedia}
}

