% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeMaxWidth.R
\name{lakeMaxWidth}
\alias{lakeMaxWidth}
\title{Function to find line representing maximum lake Width}
\usage{
lakeMaxWidth(inLakeMorpho, pointDens, intersect = FALSE, addLine = TRUE)
}
\arguments{
\item{inLakeMorpho}{An object of \code{\link{lakeMorphoClass}}.  Output of the 
\code{\link{lakeSurroundTopo}} function would be appropriate as input}

\item{pointDens}{Number of points to place equidistant along the 
\code{\link{lakeMaxLength}}. A line that crosses at that point and
extends from shore to shore is calcuated.}

\item{intersect}{Boolean to force max width to intersect the max length line.
for many lakes this will return the same line.}

\item{addLine}{Boolean to determine if the selected max length line should be 
added to the inLakeMorpho object.  Defaults to True}
}
\value{
Returns a numeric value indicating the length of the longest
        line perpndicular to the maximum length line.
}
\description{
Maximum lake width is defined as the maximum in lake distance that is 
perpendicular to the maximum lake length. As no definition specifies whether
or not the maximum lake width should intersect the line of maximum legnth, 
this function assumes that it does not, but may be forced to find the maximum 
width line the is perpendicular to and intersects with the maximum lake 
length line.  This function calculates the equation of the perpendicular line 
and repeats that line \code{pointDens}number of times and returns the longest 
of those lines.
}
\examples{
data(lakes)
lakeMaxWidth(inputLM,50)
}
\references{
Florida LAKEWATCH (2001). A Beginner's guide to water management
            - Lake Morphometry (2nd ed.). Gainesville: Florida LAKEWATCH, 
            Department of Fisheries and Aquatic Sciences.
            \href{http://edis.ifas.ufl.edu/pdffiles/FA/FA08100.pdf}{Link}
}
