% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphLand.R
\name{plotland}
\alias{plotland}
\title{Plotting the landscape}
\usage{
plotland(landscape, COL = rep(0, length(landscape)), DENS = rep(0,
  length(landscape)), ANGLE = rep(30, length(landscape)),
  COL.LEG = unique(COL), DENS.LEG = unique(DENS),
  ANGLE.LEG = unique(ANGLE), TITLE = "", SUBTITLE = "",
  LEGEND1 = rep("", length(COL.LEG)), LEGEND2 = rep("", length(COL.LEG)),
  TITLE.LEG2 = "", XMAX = 2000, YMAX = 2000)
}
\arguments{
\item{landscape}{a spatialpolygon object containing field coordinates}

\item{COL}{vector containing the color of each field}

\item{DENS}{vector containing the density of hatched lines for each field}

\item{ANGLE}{vector containing the angle of hatched lines for each field}

\item{COL.LEG}{vector containing the colors in the first legend}

\item{DENS.LEG}{vector containing the density of hatched lines in the second legend}

\item{ANGLE.LEG}{vector containing the angle of hatched lines in the second legend}

\item{TITLE}{title of the graphic}

\item{SUBTITLE}{subtitle of the graphic}

\item{LEGEND1}{labels in the first legend (colors)}

\item{LEGEND2}{labels in the second legend (hatched lines)}

\item{TITLE.LEG2}{title for the second legend}

\item{XMAX}{maximal coordinate on horizontal axis}

\item{YMAX}{maximal coordinate on vertical axis}
}
\description{
Plot a landscape with colors or hatched lines on fields
}
\examples{
\dontrun{
## Draw a landscape with various colours
landscapeTEST1
plotland(landscapeTEST1, COL=1:length(landscapeTEST1),
DENS=rep(0,length(landscapeTEST1)), ANGLE=rep(30,length(landscapeTEST1)))
}
}
