% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{loadDispersalPathogen}
\alias{loadDispersalPathogen}
\title{Load pathogen dispersal matrices}
\usage{
loadDispersalPathogen(id = 1)
}
\arguments{
\item{id}{a matrix ID between 1 to 5 (must match the ID of the landscape loaded with
\code{\link{loadLandscape}}).}
}
\value{
a vectorised dispersal matrix for clonal dispersion and a vectorised dispersal identity matrix for sexual dispersion. All by columns.
}
\description{
It loads one of the five built-in vectorised dispersal matrices of rust fungi associated with the
five built-in landscapes. Landscape and DispersalPathogen ID must be the same. And set a vectorized identity matrix
for sexual reproduction dispersal.
}
\details{
\emph{landsepi} includes built-in dispersal matrices to represent rust dispersal in the
five built-in landscapes. These have been computed from a power-law dispersal kernel:
\eqn{ g(d) = ((b-2)*(b-1) / (2*pi*a^2)) * (1 +  d/a)^(-b) }
with a=40 the scale parameter and b=7 a parameter related to the width of the dispersal kernel.
The expected mean dispersal distance is given by 2*a/(b-3)=20 m.
}
\examples{
d <- loadDispersalPathogen(1)
d
}
\seealso{
\link{dispP}, \link{setDispersalPathogen}
}
