% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_files.R
\name{read_roi_data}
\alias{read_roi_data}
\title{Read LANS data summary (.dac/.dat) files}
\usage{
read_roi_data(
  dat_folder,
  ion_data_only = TRUE,
  load_zstacks = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{dat_folder}{\itemize{
\item the LANS dat directory with the ions' .dac files
}}

\item{ion_data_only}{\itemize{
\item by default TRUE, i.e. ignores all non-ion data files
}}

\item{load_zstacks}{\itemize{
\item whether to load any z_stacks found, by default TRUE
}}

\item{quiet}{\itemize{
\item whether to report information on the loaded data or not
}}
}
\value{
concatenated data_frame with all the ROIs' data, with identifier columns 'plane', 'ROI' and 'variable'
}
\description{
Reads the ion data (.dac/.dat) files for the given LANS analysis folder
and returns the ROIs data in a concatenated data frame with identifier
columns 'ROI' and 'variable' (=ions). Note that this only reads ion data files by
default and not any derived data files (any ratio or other formulas
evaluated by LANS). If zstacks (i.e. individual planes) are exported from LANS,
they can be loaded as well (and are by default). The resulting data frame
has a 'plane' column that keeps track of the plane, the value 'all' identifies
the combined data for the ROI from all planes.
}
