% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dalex_explainers.R
\name{dalex_variable}
\alias{dalex_variable}
\title{DALEX Partial Dependency Plots (PDP)}
\usage{
dalex_variable(explainer, vars, force_class = NA)
}
\arguments{
\item{explainer}{Object. Result from \code{h2o_explainer} function.}

\item{vars}{Character vector. Which features do you wish to study?}

\item{force_class}{Character. If you wish to force a class on your 
vars, which one do you need?}
}
\value{
List. Containing PDP results, plot and \code{vars} input.
}
\description{
DALEX auxiliary function for creating Partial Dependency Plots and
study variable's responses vs independent vector.
}
\examples{
# You must have "DALEX" library to use this auxiliary function:
\dontrun{
# Having an "explainer" object created with \code{h2o_explainer}:
# For numerical variables
dalex_variable(explainer, vars = c("Age", "Fare"))
# For categorical variables
dalex_variable(explainer, vars = c("Pclass","Sex"))
}
}
\seealso{
Other Interpretability: 
\code{\link{dalex_local}()},
\code{\link{dalex_residuals}()},
\code{\link{h2o_explainer}()}
}
\concept{Interpretability}
