% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dft}
\alias{dft}
\title{Titanic Dataset}
\format{
An object of class \code{"data.frame"}
\describe{
  \item{PassengerId}{Unique ID for each passenger (1-891)}
  \item{Survived}{Did the passenger survive? (TRUE, FALSE)}
  \item{Pclass}{Ticket class, from first to third (1, 2, 3)}
  \item{Sex}{Gender (female, male)}
  \item{Age}{Age for each passenger in years (0.42-80)}
  \item{SibSp}{Amount of siblings / spouses aboard the Titanic (0-8)}
  \item{Parch}{Amount of parents / children aboard the Titanic (0-6)}
  \item{Ticket}{Ticket IDs}
  \item{Fare}{Amount paid for passenger's ticket (0-512.3292)}
  \item{Cabin}{width of top of diamond relative to widest point (43-95)}
  \item{Embarked}{Port of Embarkation (43-95)}
}
}
\usage{
data(dft)
}
\value{
data.frame
}
\description{
The sinking of the Titanic is one of the most infamous shipwrecks in history.
On April 15, 1912, during her maiden voyage, the widely considered "unsinkable"
RMS Titanic sank after colliding with an iceberg. Unfortunately, there weren’t
enough lifeboats for everyone onboard, resulting in the death of 1502 out of
2224 passengers and crew. While there was some element of luck involved in
surviving, it seems some groups of people were more likely to survive than others.
This dataset contains the details of a subset of the passengers on board
(891 to be exact) taken from Kaggle's Titanic
\href{https://www.kaggle.com/c/titanic/overview}{Train.csv}.
}
\examples{
data(dft)
head(dft)
}
\seealso{
Other Dataset: 
\code{\link{dfr}}
}
\concept{Dataset}
\keyword{datasets}
