% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{files_functions}
\alias{files_functions}
\title{List all functions used in R script files by package}
\usage{
files_functions(filename, abc = TRUE, quiet = FALSE)
}
\arguments{
\item{filename}{Character. Path to an R file (or directory)
containing R code files.}

\item{abc}{Boolean. List functions alphabetically.
If FALSE, will list in order of frequency.}

\item{quiet}{Boolean. Keep quiet? If not, print messages and
\code{statusbar}.}
}
\value{
data.frame. Each row is a function and columns stating
number of appearances, percentage, packages, and files searched.
}
\description{
Parses all functions called by an R script and then lists
them by package. Wrapper for 'getParseData'. May be of great
use for those developing a package to help see what
namespace 'importsFrom' calls will be required.
}
\examples{
\dontrun{
# Choose an R script file with functions
rfile <- file.choose()
files_functions(rfile)
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
