% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{autoline}
\alias{autoline}
\title{New Line Feed for Long Strings (Wrapper)}
\usage{
autoline(text, top = "auto", rel = 9)
}
\arguments{
\item{text}{Character or factor vector.}

\item{top}{Integer. How many characters aprox. should be on each line?}

\item{rel}{Numeric. Relation of pixels and characters per line}
}
\value{
Character. String (vector) including some \code{\\n} within.
}
\description{
Add a break or new line without breaking words. Automatically,
the function can detect your plot's width and will dynamically
set an auto width. You can adjust the relation (rel) parameter
for different fonts and sizes until perfect harmony found.
Quite similar to \code{stringr::str_wrap} but, if the text vector
is a factor, the levels will be kept in order and transformed.
}
\examples{
cat(autoline("This is a long text that may not fit into a single line", 8))

text <- factor(c("First value", "Second value", "First value"),
  levels = c("First value", "Second value")
)
autoline(text, 1)

path <- file.path(R.home("doc"), "THANKS")
text <- paste(readLines(path), collapse = " ")
cat(autoline(text))
}
\seealso{
Other Tools: 
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{chr2num}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
