% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onehotencoding.R
\name{holidays}
\alias{holidays}
\title{Holidays in your Country}
\usage{
holidays(
  countries = "Venezuela",
  years = year(Sys.Date()),
  quiet = FALSE,
  include_regions = FALSE
)
}
\arguments{
\item{countries}{Character or vector. For which country(ies) should the
holidays be imported?}

\item{years}{Character or vector. For which year(s) do you wish to import
holiday dates?}

\item{quiet}{Boolean. Default FALSE which disables verbosity of the function.}

\item{include_regions}{Boolean. Default FALSE. If TRUE, for countries with 
internal subdivisions, it will provide details on which sub-state the found 
holidays apply.}
}
\value{
\code{data.frame} with holidays data for given \code{countries} and \code{years}.
}
\description{
This function lets the user automatically scrap holiday dates from
any country and year within +- 5 years. Thanks to timeanddate.com!
}
\examples{
\donttest{
holidays(countries = "Argentina")
holidays(countries = c("Argentina", "Venezuela"), years = c(2019, 2020))
holidays(countries = "Germany", years = 2021:2023, include_regions = TRUE)
}
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}

Other Feature Engineering: 
\code{\link{date_feats}()},
\code{\link{ohse}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_quote}()}

Other One Hot Encoding: 
\code{\link{date_feats}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()}
}
\concept{Data Wrangling}
\concept{Feature Engineering}
\concept{One Hot Encoding}
\concept{Scrapper}
