% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optics.R
\name{lv_optics}
\alias{lv_optics}
\title{lv_optics}
\usage{
lv_optics(edges, neighbors, eps = Inf, minPts = nrow(neighbors), eps_cl, xi,
  useQueue = TRUE, verbose = getOption("verbose", TRUE))
}
\arguments{
\item{edges}{A weighted graph of the type produced by \code{\link{buildEdgeMatrix}}. Alternatively, a \code{largeVis} object,
in which case \code{edges} and \code{neighbors} will be taken from the \code{edges} and \code{knns} parameters, respectively.}

\item{neighbors}{An adjacency matrix of the type produced by \code{\link{randomProjectionTreeSearch}}}

\item{eps}{See \code{\link[dbscan]{optics}}.}

\item{minPts}{See \code{\link[dbscan]{optics}}.}

\item{eps_cl}{See \code{\link[dbscan]{optics}}.}

\item{xi}{See \code{\link[dbscan]{optics}}.}

\item{useQueue}{Whether to process points in order of core distance.  (See note.)}

\item{verbose}{Vebosity level.}
}
\value{
An \code{\link[dbscan]{optics}} object.
}
\description{
Experimental implementation of the OPTICS algorithm.
}
\details{
This is an implementation of the OPTICS algorithm that attempts
to leverage the \code{largeVis} nearest-neighbor search.

This implementation does not use the OPTICS neighbor-search strategy, in favor of using the pre-calculated
neighbor matrix produced incidentally by \code{largeVis}. It is therefore a variant of OPTICS rather than an
implementation of the original, and the results vary slightly from those obtained by the implementations in
\code{ELKI} and the \code{dbscan} package.
}
\note{
The \code{useQueue} parameter controls the order in which points that have not yet been visisted are processed. If \code{FALSE},
points are processed in order of rows. If \code{TRUE}, they are processed in ascending order of core distance. \code{FALSE} is more
compatible with the implementations in the \code{dbscan} package and in the \code{ELKI} Java clustering package. \code{TRUE} may produce
preferrable results.
}
\references{
Mihael Ankerst, Markus M. Breunig, Hans-Peter Kriegel, Jorg Sander (1999). OPTICS: Ordering Points To Identify the Clustering Structure. ACM SIGMOD international conference on Management of data. ACM Press. pp. 49-60.
}
