% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodCrimCV.R
\name{lcMethodCrimCV}
\alias{lcMethodCrimCV}
\title{Specify a zero-inflated repeated-measures GBTM method}
\usage{
lcMethodCrimCV(
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{...}{Arguments passed to \link[crimCV:crimCV]{crimCV::crimCV}.
The following external arguments are ignored: Dat, ng.}
}
\description{
Specify a zero-inflated repeated-measures GBTM method
}
\examples{
\donttest{
library(crimCV)
data(latrendData)
method <- lcMethodCrimCV("Y", id = "Id", time = "Time", nClusters = 3, dpolyp = 1, init = 2)
model <- latrend(method, data = subset(latrendData, Time > .5))
plot(model)

data(TO1adj)
method <- lcMethodCrimCV(response = "Offenses", time = "Offense", id = "Subject",
  nClusters = 2, dpolyp = 1, init = 2)
model <- latrend(method, data = TO1adj[1:100, ])
}
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAKMedoids}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}},
\code{\link{lcMethodTwoStep}}
}
\concept{lcMethod implementations}
