% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{trajectories}
\alias{trajectories}
\alias{trajectories,lcModel-method}
\title{Extract the fitted trajectories for all strata}
\usage{
trajectories(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)

\S4method{trajectories}{lcModel}(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)
}
\arguments{
\item{object}{The model.}

\item{at}{The time points at which to compute the id-specific trajectories.}

\item{what}{The distributional parameter to compute the response for.}

\item{clusters}{The cluster assignments for the strata to base the trajectories on.}

\item{...}{Additional arguments.}
}
\description{
Extract the fitted trajectories for all strata
}
\examples{
data(latrendData)
model <- latrend(method = lcMethodKML("Y", id = "Id", time = "Time"), data = latrendData)
trajectories(model)

trajectories(model, at = c(0, .5, 1))
}
\seealso{
Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
