% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\title{Test a condition}
\usage{
test(
  key = "test",
  x,
  y = TRUE,
  error = FALSE,
  warning = FALSE,
  runOnly = FALSE,
  text = "",
  onFail = c("fail", "warn", "ignore", "skip"),
  ...
)
}
\arguments{
\item{key}{Identifier for the test condition.}

\item{x}{The expression to test.}

\item{y}{The reference value or expression.}

\item{error}{Whether to expect an error, or the pattern that the error message should match.}

\item{warning}{Whether to expect a warning, or the pattern that the warning message should match.}

\item{runOnly}{Whether to skip the comparison to \code{y}. If disabled, an error is raised when \code{y} is not \code{TRUE}.}

\item{text}{Human-readable description of what this test condition is testing.}

\item{onFail}{How to handle a failure of the test condition. By default, this is recorded as a test failure.
If \code{onFail = "skip"}, the condition is not tested.}

\item{...}{Additional arguments passed to \code{\link[base:all.equal]{base::all.equal()}}}
}
\value{
Whether the test condition has passed successfully. In case of \code{onFail = "skip"}, \code{NA} is returned.
}
\description{
Evaluate or compare an expression based on a reference expression, or test for errors.
The comparison of expression values is done using \code{\link[base:all.equal]{base::all.equal()}}.
}
\details{
Inspired by the \code{data.table} package test mechanism.
The original motivation for this function is the lack of R support for a proper stack trace with line numbers when sourcing files,
which made it practically impossible to identify the offending line in a sourced file.
}
\examples{
\dontrun{
test('gt', 2 > 1)
test('eq', 1 + 1, 2)
test('lt', 2 < 1, onFail = "warn")
}
}
\keyword{internal}
