% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/count.R
\name{lawn_count}
\alias{lawn_count}
\title{Count number of points within polygons}
\usage{
lawn_count(polygons, points, countField = "pt_count", lint = FALSE)
}
\arguments{
\item{polygons}{Geojson polygons}

\item{points}{Geojson points}

\item{countField}{(character) A field to append to the attributes of the Polygon features
representing Point counts}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
a \code{\link{data-FeatureCollection}}
}
\description{
Calculates the number of \code{\link{data-Point}}'s that fall within the set
of \code{\link{data-Polygon}}'s
}
\examples{
# using data in the package
cat(lawn_data$points_count)
cat(lawn_data$polygons_count)
lawn_count(polygons = lawn_data$polygons_count, points = lawn_data$points_count)
}
\seealso{
Other aggregations: \code{\link{lawn_aggregate}};
  \code{\link{lawn_average}}; \code{\link{lawn_deviation}};
  \code{\link{lawn_max}}; \code{\link{lawn_median}};
  \code{\link{lawn_min}}; \code{\link{lawn_sum}};
  \code{\link{lawn_variance}}
}

