% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reclass.R
\name{lawn_reclass}
\alias{lawn_reclass}
\title{Reclassify properties data}
\usage{
lawn_reclass(input, inField, outField, translations, lint = FALSE)
}
\arguments{
\item{input}{Set of input features}

\item{inField}{the field to translate}

\item{outField}{the field in which to store translated results}

\item{translations}{an array of translations. Use nested lists instead of vectors
as combined numerics and characters will become all character strings when converted
to json. Each list within the nested list of length 3, of the form
\code{<lower limit>, <upper limit>, <name for new grouping>}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
a \code{\link{data-FeatureCollection}} with identical geometries to
input but with outField populated.
}
\description{
Takes a \code{\link{data-FeatureCollection}}, an input field, an output field,
and an array of translations and outputs an identical FeatureCollection with
the output field property populated
}
\examples{
t1 <- list(list(0, 200, "small"), list(200, 400, "medium"), list(400, 600, "large"))
lawn_reclass(lawn_data$points_average, 'population', 'size', t1)
lawn_reclass(lawn_data$points_average, 'population', 'number', t1)

t2 <- list(list(0, 150, "small"), list(150, 700, "big"))
lawn_reclass(lawn_data$points_average, 'population', 'size', t2)
}
\seealso{
Other classification: \code{\link{lawn_jenks}};
  \code{\link{lawn_nearest}}; \code{\link{lawn_quantile}}
}

