% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.feature.R
\name{as.feature}
\alias{as.feature}
\title{Coerce character strings or JSON to GeoJSON Feature}
\usage{
as.feature(x, ...)
}
\arguments{
\item{x}{a character string or json class with a GeoJSON object, any
of feature, point, multipoint, linestring, multilinestring, polygon,
or multipolygon. featurecollection and geometrycollection simply returned
without alteration}

\item{...}{ignored}
}
\value{
a \code{feature} class object
}
\description{
Coerce character strings or JSON to GeoJSON Feature
}
\examples{
poly <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [105.818939,21.004714],
      [105.818939,21.061754],
      [105.890007,21.061754],
      [105.890007,21.004714],
      [105.818939,21.004714]
     ]]
  }
}'
as.feature(poly)

pt <- '{"type":"Point","coordinates":[-75.343,39.984]}'
as.feature(pt)

line <- '{
  "type": "LineString",
  "coordinates": [
    [-77.031669, 38.878605],
    [-77.029609, 38.881946],
    [-77.020339, 38.884084],
    [-77.025661, 38.885821],
    [-77.021884, 38.889563],
    [-77.019824, 38.892368]
    ]
}'
as.feature(line)

# returns self if no match - note "Points" is not a GeoJSON type
pt <- '{"type":"Points","coordinates":[-75.343,39.984]}'
as.feature(pt)
}
