% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max.R
\name{lawn_max}
\alias{lawn_max}
\title{Maximum value of a field among points within polygons}
\usage{
lawn_max(polygons, points, in_field, out_field = "max", lint = FALSE)
}
\arguments{
\item{polygons}{a \code{\link{data-FeatureCollection}} of
\code{\link{data-Polygon}} features}

\item{points}{a \code{\link{data-FeatureCollection}} of
\code{\link{data-Point}} features}

\item{in_field}{(character) the field in input data to analyze}

\item{out_field}{(character) the field in which to store results}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A FeatureCollection of \link{data-Polygon} features with
properties listed as \code{out_field}.
}
\description{
Calculates the maximum value of a field for a set of \link{data-Point}'s
within a set of \link{data-Polygon}'s.
}
\examples{
\dontrun{
poly <- lawn_data$polygons_average
pt <- lawn_data$points_average
lawn_max(poly, pt, 'population')
}
}
\seealso{
Other aggregations: \code{\link{lawn_average}},
  \code{\link{lawn_collect}}, \code{\link{lawn_count}},
  \code{\link{lawn_deviation}}, \code{\link{lawn_median}},
  \code{\link{lawn_min}}, \code{\link{lawn_sum}},
  \code{\link{lawn_variance}}
}
