% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolines.R
\name{lawn_isolines}
\alias{lawn_isolines}
\title{Generate Isolines}
\usage{
lawn_isolines(points, breaks, z, propertiesToAllIsolines = c(),
  propertiesPerIsoline = list(), resolution = NULL, lint = FALSE)
}
\arguments{
\item{points}{Input points. a point grid, e.g., output of \code{\link[=lawn_point_grid]{lawn_point_grid()}}}

\item{breaks}{(numeric) Where to draw contours.}

\item{z}{(character) The property name in points from which z-values will
be pulled.}

\item{propertiesToAllIsolines}{GeoJSON properties passed to ALL isolines}

\item{propertiesPerIsoline}{GeoJSON properties passed, in order, to the
correspondent isoline; the breaks array will define the order in which the
isolines are created}

\item{resolution}{(numeric) Resolution of the underlying grid. THIS
PARAMETER IS DEFUNCT}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
A \link{data-FeatureCollection} of isolines
(\link{data-LineString} features).
}
\description{
Takes \link{data-Point}'s with z-values and an array of value
breaks and generates \href{http://en.wikipedia.org/wiki/Isoline}{isolines}
}
\details{
Warning: this function seems to be broken, not sure why
}
\examples{
\dontrun{
# pts <- lawn_random(n = 100, bbox = c(0, 30, 20, 50))
pts <- lawn_point_grid(c(0, 30, 20, 50), 100, 'miles')
pts$features$properties <-
  data.frame(temperature = round(rnorm(NROW(pts$features), mean = 5)),
  stringsAsFactors = FALSE)
breaks <- c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
lawn_isolines(points = pts, breaks, z = 'temperature')

lawn_isolines(pts, breaks, 'temperature') \%>\% view
}
}
\seealso{
Other interpolation: \code{\link{lawn_hex_grid}},
  \code{\link{lawn_planepoint}},
  \code{\link{lawn_point_grid}},
  \code{\link{lawn_square_grid}}, \code{\link{lawn_tin}},
  \code{\link{lawn_triangle_grid}}
}
\concept{interpolation}
