% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unkinkpolygon.R
\name{lawn_unkinkpolygon}
\alias{lawn_unkinkpolygon}
\title{Unkink polygon}
\usage{
lawn_unkinkpolygon(x, lint = FALSE)
}
\arguments{
\item{x}{A \link{data-FeatureCollection}<(\link{data-Polygon})> or
\link{data-FeatureCollection}<(\link{data-MultiPolygon})>}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-FeatureCollection}<(\link{data-Polygon})>
}
\description{
Takes a kinked polygon and returns a feature collection of polygons
that have no kinks.
}
\examples{
x <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Polygon",
      "coordinates": [[[0, 0], [2, 0], [0, 2], [2, 2], [0, 0]]]
   }
}'
lawn_unkinkpolygon(x)
view(x)
view(lawn_unkinkpolygon(x))
}
\seealso{
Other grids: \code{\link{lawn_idw}}
}
\concept{grids}
