% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propeach.R
\name{lawn_propeach}
\alias{lawn_propeach}
\title{Iterate over property objects in any GeoJSON object}
\usage{
lawn_propeach(x, fun = NULL, lint = FALSE)
}
\arguments{
\item{x}{any \link{data-GeoJSON} object}

\item{fun}{a Javascript function. if not given, returns self}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
matrix of coordinates, where each row in the matrix is a
coordinate pair
}
\description{
Iterate over property objects in any GeoJSON object
}
\examples{
x <- "{ type: 'Feature', geometry: null, properties: { foo: 1, bar: 3 } }"

# don't apply any function, identity essentially
lawn_propeach(x)

# appply a function callback
lawn_propeach(x, "z.foo === 1")

lawn_propeach(lawn_data$points_count)

z <- '{
  "type": "FeatureCollection",
  "features": [
    {
      "type": "Feature",
      "properties": {
        "population": 200,
        "name": "things"
      },
      "geometry": {
        "type": "Point",
        "coordinates": [-112.0372, 46.608058]
      }
    }, {
      "type": "Feature",
      "properties": {
        "population": 600,
        "name": "stuff"
      },
      "geometry": {
        "type": "Point",
        "coordinates": [-112.045955, 46.596264]
      }
    }
    ]
}'
lawn_propeach(z)
lawn_propeach(z, "z.population === 200")
lawn_propeach(z, "z.name === 'stuff'")
}
