% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lazy.figure.R
\name{lazy.figure}
\alias{lazy.figure}
\title{Include Figures in Latex Documents}
\usage{
lazy.figure(filename, caption = NULL, align = "center", height = 3,
  width = 3, units = "in", counter, counterSet = NULL, label = NULL,
  placement = "h", alt = "Image Not Found",
  cat = getOption("lazyWeave_cat"))
}
\arguments{
\item{filename}{Character string giving the location of the file to be included}

\item{caption}{Text giving the caption for the figure}

\item{align}{Character string stating the alignment.  Valid options are
\code{"left"}, \code{"right"}, or \code{"center"}}

\item{height}{The height of the figure}

\item{width}{The width of the figure}

\item{units}{The units for height and width.  Defaults to \code{"in"}.}

\item{counter}{Name of a counter to use to number the table}

\item{counterSet}{The number to which \code{counter} should be set.
In other words, the figure number for this figure}

\item{label}{Name of a label}

\item{placement}{Controls the placement of the figure.  Options are
\code{"ht", "t", "b", "p", "H"} and can be supplemented with
\code{"!"}. See "Details" for more explanation}

\item{alt}{For HTML documents only--when \code{filename} cannot be found,
this text is printed in the figure's place}

\item{cat}{Logical. Determines if the output is returned as a character string
  or returned via the \code{cat} function (printed to console).  The default
  value is set by \code{options()$lazyWeave_cat}.  This argument allows for
  selective override of the default.}
}
\description{
Include Figures in Latex Documents
}
\details{
Generates the code to place a figure in a Latex document
}
\examples{
\dontrun{
pdf("MPG.pdf", height=4, width=4)
hist(mtcars$mpg)
dev.off()

lazy.figure("MPG.pdf")

lazy.write(
lazy.file.start(),
lazy.figure("MPG.pdf",
caption="Distribution of Miles per Gallon in mtcars dataset",
height=5, width=5, label="MPGgraph"),
lazy.file.end(),
OutFile="Example-1.tex")

unlink("MPG.pdf")
unlink("Example-1.tex")
unlink("Example-1.pdf")
}
}
\author{
Benjamin Nutter
}

