% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lazy_dots}
\alias{lazy_dots}
\title{Capture ... (dots) for later lazy evaluation.}
\usage{
lazy_dots(..., .follow_symbols = FALSE)
}
\arguments{
\item{...}{Dots from another function}

\item{.follow_symbols}{If \code{TRUE}, the default, follows promises across
function calls. See \code{vignette("chained-promises")} for details.}
}
\value{
A named list of \code{\link{lazy}} expressions.
}
\description{
Capture ... (dots) for later lazy evaluation.
}
\examples{
lazy_dots(x = 1)
lazy_dots(a, b, c * 4)

f <- function(x = a + b, ...) {
  lazy_dots(x = x, y = a + b, ...)
}
f(z = a + b)
f(z = a + b, .follow_symbols = TRUE)

# .follow_symbols is off by default because it causes problems
# with lazy loaded objects
lazy_dots(letters)
lazy_dots(letters, .follow_symbols = TRUE)

# You can also modify a dots like a list. Anything on the RHS will
# be coerced to a lazy.
l <- lazy_dots(x = 1)
l$y <- quote(f)
l[c("y", "x")]
l["z"] <- list(~g)

c(lazy_dots(x = 1), lazy_dots(f))
}

