% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-rect.R
\name{lcarsRect}
\alias{lcarsRect}
\alias{lcarsPill}
\alias{lcarsLeftPill}
\alias{lcarsRightPill}
\title{LCARS rectangle element}
\usage{
lcarsRect(
  text = "",
  round = c("none", "both", "left", "right"),
  decorate = c("none", "both", "left", "right"),
  color = "golden-tanoi",
  text_color = "#000000",
  title_color = color,
  text_size = 16,
  title = NULL,
  width = "100\%",
  height = 30
)

lcarsPill(
  text = "",
  decorate = c("none", "both", "left", "right"),
  color = "golden-tanoi",
  text_color = "#000000",
  title_color = color,
  text_size = 16,
  title = NULL,
  width = "100\%",
  height = 30
)

lcarsLeftPill(
  text = "",
  decorate = FALSE,
  color = "golden-tanoi",
  text_color = "#000000",
  title_color = color,
  text_size = 16,
  title = NULL,
  width = "100\%",
  height = 30
)

lcarsRightPill(
  text = "",
  decorate = FALSE,
  color = "golden-tanoi",
  text_color = "#000000",
  title_color = color,
  text_size = 16,
  title = NULL,
  width = "100\%",
  height = 30
)
}
\arguments{
\item{text}{character, rectangle text.}

\item{round}{character, sides of rectangle to round to make an LCARS pill or
half pill.}

\item{decorate}{character, sides of rectangle to decorate with cut pill;
applicable if a given side is rounded via \code{round}. Logical for
\code{lcarsLeftPill} and \code{lcarsRightPill}.}

\item{color}{rectangle color. Any hex color or a named LCARS color.}

\item{text_color}{text color. Any hex color or a named LCARS color.}

\item{title_color}{title color. Any hex color or a named LCARS color.}

\item{text_size}{size of \code{text} in pixels.}

\item{title}{optional title text to insert in blank gap in rectangle. Used
for header-style rectangles.}

\item{width}{a valid CSS unit.}

\item{height}{a valid CSS unit.}
}
\value{
a div
}
\description{
A basic rectangle HTML element that conforms to LCARS specifications.
}
\details{
While \code{text} can be made arbitrarily large using \code{text_size}, the
font size of the optional \code{title} is fixed at standard header size
(\code{height = 0.5}).
}
\examples{
if (interactive()) {

  ui <- lcarsPage(
    fluidRow(
      column(4,
        h4("Rectangle"),
        lcarsRect("Some text.", text_size = 24, width = 200),
        h4("Pill"),
        lcarsPill("Some text.", text_size = 24, width = 200)
      )
    )
  )

  server <- function(input, output) {}

  shinyApp(ui, server)
}
}
