% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville_extreme.R
\name{pickands.liouv}
\alias{pickands.liouv}
\title{Pickands dependence function for the copula domain of attraction of Liouville survival copulas}
\usage{
pickands.liouv(t, rho = 0.5, alpha = c(1, 1), CDA = c("C", "S"))
}
\arguments{
\item{t}{pseudo-angle in (0,1)}

\item{rho}{index of regular variation parameter}

\item{alpha}{vector of Dirichlet allocations. Currently must be of length 2}

\item{CDA}{select the extremal attractor of the copula (\code{C}) or the survival copula (\code{S})}
}
\value{
value of Pickands function for the scaled Dirichlet EV model
}
\description{
Pickands dependence function as in \cite{Belzile (2014), Proposition 40 and Example 4} and
\cite{Belzile (2014), Proposition 41}, assuming that the parameter alpha is integer-valued.
Returns the Pickands dependence function of the copula domain of attraction (CDA)
of the survival copula, the scaled Dirichlet extreme value model, or the CDA of the copula, the Liouville EV model.
}
\examples{
pickands.liouv(seq(0,1,by=0.01),1,c(0.1,0.3),CDA="S")
pickands.liouv(t = seq(0,1,by=0.01), rho = 0.5, alpha = c(1,3), CDA="C")
}

