% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{rliouv}
\alias{rliouv}
\title{Liouville copula sampler}
\usage{
rliouv(n = 100, family, alphavec, theta, reverse = FALSE)
}
\arguments{
\item{n}{sample size}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers) Specifies (implictly) the dimension of sample}

\item{theta}{parameter of the corresponding Archimedean copula}

\item{reverse}{if \code{TRUE}, return sample from the corresponding survival copula}
}
\value{
a sample of dimension \code{n} by \code{length(alphavec)} from the Liouville copula
}
\description{
Liouville copula sampler
}
\examples{
# Sample from a Gumbel Liouville copula
rliouv(n = 100, family = "gumbel", alphavec = c(2, 3), theta = 2)
}

