% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{isliouv_m}
\alias{isliouv_m}
\title{Multiple marginal inverse survival function of Liouville vectors}
\usage{
isliouv_m(u, family, alphavec, theta)
}
\arguments{
\item{u}{vector of survival probabilities}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
a vector of same length as \code{u} with the quantile at 1-u
}
\description{
This function is a wrapper around \code{\link{isliouvm}}; it allows the user to treat all the data matrix simultaneously
by applying different parameters to each margin.
}
\examples{
u <- rliouv(n = 10, family = "clayton", alphavec <- c(2,3), theta = 2)
isliouv_m(u=u, family="clayton", alphavec=c(2,3), theta=2)
}

