% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{RemoveNaStrategies}
\alias{RemoveNaStrategies}
\title{Remove NA and Count the Number of Observations in Different Scenarios}
\usage{
RemoveNaStrategies(data, countFun = function(nRows, nCols) nRows * nCols)
}
\arguments{
\item{data}{A matrix with NA}

\item{countFun}{a function to determine how strategies are sorted.
Default counts the number of observations. You might want to give columns a
higher level of importance for example by using \code{nRows*nCols^1.5}.}
}
\value{
a list of lists with four elements:
\itemize{
\item nRows: number of rows in the matrix
\item nCols: number of cols in the matrix
\item colFirst: whether to remove columns or rows first
\item colRemove: indexes of the columns to be removed
\item rowRemove: indexes of the rows to be removed
}
}
\description{
When a matrix has NA, one can omit columns with NA or rows with NA or a combination of these two.
Total number of observations is a function the order.
This function tries all combinations returns the results.
}
\examples{
data <- matrix(c(NA, 2, 3, 4, NA, 5, NA, 6, 7, NA, 9, 10, 11, 12, 13, 14, 15, NA, 16, 17), 4, 5)
RemoveNaStrategies(data)
}
