% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{k.coefficient}
\alias{k.coefficient}
\title{Calculate k coefficient provided a known real LAI and the
calculated LAI}
\usage{
k.coefficient(lidar.lai, real.lai = 6)
}
\arguments{
\item{lidar.lai}{the output from lai() function}

\item{real.lai}{numeric, known real LAI}
}
\description{
Calculate k coefficient provided a known real LAI and the
calculated LAI
}
\examples{
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

# Calculate LAD from voxelization
VOXELS_LAD = lad.voxels(normlas.file,
                        grain.size = 2)

# Calculate the LAD profile
lad_profile = lad.profile(VOXELS_LAD)

# Calculate LAI derived from LAD profile
lidar.lai = lai(lad_profile); lidar.lai

# The real LAI was measured in the field work for validation
k.coefficient(lidar.lai,  real.lai = 6)

}
