% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tutorial-state.R
\name{get_tutorial_state}
\alias{get_tutorial_state}
\title{Observe the user's progress in the tutorial}
\usage{
get_tutorial_state(label = NULL, session = getDefaultReactiveDomain())
}
\arguments{
\item{label}{A length-1 character label of the exercise or question.}

\item{session}{The \code{session} object passed to function given to
\code{shinyServer.} Default is \code{\link[shiny:domains]{shiny::getDefaultReactiveDomain()}}.}
}
\value{
A reactiveValues object or a single reactive value (if \code{label} is
provided). The names of the full reactiveValues object correspond to the
label of the question or exercise. Each item contains the following
entries:
\itemize{
\item \code{type}: One of \code{"question"} or \code{"exercise"}.
\item \code{answer}: A character vector containing the user's submitted answer(s).
\item \code{correct}: A logical indicating whether the user's answer was correct,
or a logical \code{NA} if the submission was not checked for correctness.
\item \code{timestamp}: The time at which the user's submission was completed, as
a character string in UTC, formatted as \code{"\%F \%H:\%M:\%OS3 \%Z"}.
}
}
\description{
As a student progresses through a \pkg{learnr} tutorial, their progress is
stored in a Shiny reactive values list for their session (see
\code{\link[shiny:reactiveValues]{shiny::reactiveValues()}}). Without arguments, \code{get_tutorial_state()} returns
the full reactiveValues object that can be converted to a conventional list
with \code{\link[shiny:reactiveValuesToList]{shiny::reactiveValuesToList()}}. If the \code{label} argument is provided,
the state of an individual question or exercise with that label is returned.

Calling \code{get_tutorial_state()} introduces a reactive dependency on the state
of returned questions or exercises unless called within \code{isolate()}. Note
that \code{get_tutorial_state()} will only work for the tutorial author and must
be used in a reactive context, i.e. within \code{\link[shiny:observe]{shiny::observe()}},
\code{\link[shiny:observeEvent]{shiny::observeEvent()}}, or \code{\link[shiny:reactive]{shiny::reactive()}}. Any logic observing the
user's tutorial state must be written inside a \code{context="server"} chunk in
the tutorial's R Markdown source.
}
\seealso{
\code{\link[=get_tutorial_info]{get_tutorial_info()}}
}
