% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{sensitivity3.lefkoMat}
\alias{sensitivity3.lefkoMat}
\title{Calculate Sensitivity of Lambda to Matrix Elements for a lefkoMat Object}
\usage{
\method{sensitivity3}{lefkoMat}(mats)
}
\arguments{
\item{mats}{An object of class \code{lefkoMat}.}
}
\value{
The output from this function depends on whether the input is a
historical or ahistorical \code{lefkoMat} object. If the latter, then this
function returns a list with five elements, the first being a list of
sensitivity matrices corresponding to the \code{$A} matrices in a
\code{lefkoMat} object, and the second being a data frame showing the order
of stages. If the former, then the output also includes the equivalent
sensitivities to ahistorical transitions estimated using the historical
matrix, and a data frame detailing the order of historical paired stages. The
output also includes the A, U, and F matrices used to develop the elasticity
matrices.
}
\description{
\code{sensitivity3.lefkoMat()} returns the sensitivities of lambda to
elements of all \code{$A} matrices in an object of class \code{lefkoMat}.
This function can handle large and sparse matrices, and so can be used with
large historical matrices, IPMs, age x stage matrices, as well as smaller
ahistorical matrices.
}
\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"),
  stage2 = c("Sd", "Sd", "Sd"), stage1 = c("Sd", "rep", "rep"),
  givenrate = c(0.345, 0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  repmatrix = lathrepm, overwrite = lathover3, yearcol = "year2",
  indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
sensitivity3(ehrlen3mean)

}
\seealso{
\code{\link{sensitivity3}()}

\code{\link{sensitivity3.matrix}()}
}
