% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.numeric.lfactor.R
\name{as.numeric.lfactor}
\alias{as.numeric.lfactor}
\title{Numeric Vectors from lfactors}
\usage{
\method{as.numeric}{lfactor}(x, ...)
}
\arguments{
\item{x}{same as \code{\link[base]{as.numeric}}}

\item{\dots}{not used}
}
\description{
Returns numeric representation of an lfactor equal to the \code{levels} argument for each value. This is
different from the behavior of factor which would ignore the values of \code{level}.
}
\details{
This method does not return floating point (numeric) results that are otherwise equal to the results from \code{\link{as.integer.lfactor}}.
Instead it returns the value of the level that was input when the lfactor was created.
}
\examples{
require(lfactors)
# create an example
let <- lfactor(4:12,
               levels=4:12,
               labels=letters[4:12])

as.numeric(let)
#same as as.numeric(4:12)
as.integer(let)
#same as 1:9

}
\seealso{
\code{\link[base]{as.numeric}}, \code{\link{as.integer.lfactor}}
}

