% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldcat-api.R
\name{worldcat_api_classify_by}
\alias{worldcat_api_classify_by}
\alias{worldcat_api_classify_by_oclc}
\alias{worldcat_api_classify_by_isbn}
\alias{worldcat_api_classify_by_issn}
\title{Search WorldCat classify API by ISBN, ISSN, or OCLC number}
\usage{
worldcat_api_classify_by_oclc(x, print.api.responses = FALSE)

worldcat_api_classify_by_isbn(x, print.api.responses = FALSE)

worldcat_api_classify_by_issn(x, print.api.responses = FALSE)
}
\arguments{
\item{x}{A string representation of the standard number that the function
chosen accepts.}

\item{print.api.responses}{A logical indicating whether the HTTP and
classify API responses should be printed
(for debugging) (default is \code{FALSE})}
}
\value{
A \code{data.table} with most popular DCC and LCC call numbers
        and various other metadata. See "Details" for more information.
}
\description{
Access the results of a WorldCat classify API search by ISBN, ISSN,
or OCLC number to get the most frequent call numbers (DCC and LCC)
associated with a work. Returns a \code{data.table} with those call
numbers and various other metadata. See "Details" for more information.
}
\details{
The returned \code{data.table} contains fields for various pieces of
metadata returned by the API request. These fields include the
ISBN/ISSN/OCLC number used, title of work, author, total number of
holdings, total number of electronic holdings, call number type,
call number recommendation (by most popular), number of holdings
using that call number, the HTTP status code, and the Classify
API response code.

For each ISBN/ISSN/OCLC number used, two rows will be returned; one for
the DCC and one for the LCC. Common information (work metadata)
will the the same in both rows. If one of the call numbers is missing,
the recommendation and holdings fields will be NA.

The API can be persnickety, and there are many things that can go
wrong. For example, the API can respond with multiple works for a
single standard number (ISBN 9780900565748, for example). If this happens,
no attempt is made to follow one of the results, and the returned
\code{data.table} will return no useful information.

If the \code{http_status_code} is 200 and the \code{classify_response_code}
is 0, you've received good results.If the \code{classify_response_code} is
4, the standard number may have returned multiple works.

The \code{http_status_code} should never not be 200.

If something went wrong (for example, the status/response codes are not
200 and 0, respectively), you may want to re-run the function call with
\code{print.api.responses} set to \code{TRUE}. This will print the
HTTP status code and the raw XML text response from the API.

As with all API access functions in this package, it's up to the
user to limit their API usage so as to not get blocked. These
functions are deliberately not vectorized for this reason; they
only accept one standard number at a time.

Final note: all of these API functions seem to work better with
OCLC numbers than any other standard number. If multiple standard
numbers are available, using the OCLC number is always preferred.
}
\examples{

\dontrun{
  worldcat_api_classify_by_oclc("93976650")
   #         oclc   title           author total_holdings total_eholdings call_type
   #       <char>  <char>           <char>          <int>           <int>    <char>
   # 1: 939766505 Lobster King, Richard J.            244             534       DCC
   # 2: 939766505 Lobster King, Richard J.            244             534       LCC
   #    recommendation holdings http_status_code classify_response_code
   #            <char>   <char>            <int>                  <int>
   # 1:        641.395      767              200                      0
   # 2:      QL444.M33      318              200                      0

}

}
