% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_add}
\alias{lib_add}
\title{Add Data to a Data Library}
\usage{
lib_add(x, ..., name = NULL)
}
\arguments{
\item{x}{The library to add data to.}

\item{...}{The data frame(s) to add to the library.  If more than one,
separate with commas.}

\item{name}{The reference name to use for the data.  By default,
the name will be the variable name.  To assign a name different
from the variable name, assign a quoted name to this parameter.  If more
than one data set is being appended, assign a vector of quoted names.}
}
\description{
The \code{\link{lib_add}} function adds a data frame
or tibble to an existing data library.  The function will both add the data
to the library list, and immediately write the data to the library
directory location. The data will be written to disk
in the file format associated with the library engine. 
If the library is loaded, the function will also 
add the data to the workspace environment.
}
\examples{
#' # Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)
# # library 'dat': 0 items
# - attributes: rds not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# NULL

# Add data to the library
lib_add(dat, mtcars, beaver1, iris)
# library 'dat': 3 items
# - attributes: not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#      Name Extension Rows Cols   Size        LastModified
# 1  mtcars       rds   32   11 7.5 Kb 2020-11-05 19:32:00
# 2 beaver1       rds  114    4 5.1 Kb 2020-11-05 19:32:04
# 3    iris       rds  150    5 7.5 Kb 2020-11-05 19:32:08

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
