% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_unload}
\alias{lib_unload}
\title{Unload a Library from the Workspace}
\usage{
lib_unload(x, sync = TRUE, name = NULL)
}
\arguments{
\item{x}{The data library to unload.}

\item{sync}{Whether to sync the workspace with the library list before
it is unloaded.  Default is TRUE. If you want to unload the workspace 
without saving the workspace data, set this parameter to FALSE.}

\item{name}{The name of the library to unload, if the name is different
than the variable name.  Used internally.}
}
\value{
The unloaded data library.
}
\description{
The \code{lib_unload} function unloads a data library from
the workspace environment.  The unload function does not delete the data 
or remove the library.  It simply removes the data frames from working 
memory.  By default, the \code{lib_unload} function will also synchronize the 
data in working memory with the data stored in the library list, as these
two instances can become out of sync if you change the data in working memory.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Add data to library
lib_add(dat, iris, ToothGrowth, PlantGrowth)

# Load library into workspace
lib_load(dat)

# Examine workspace
ls()
# [1] "dat" "dat.iris" "dat.PlantGrowth" "dat.ToothGrowth" "tmp"

# Use some data
summary(dat.PlantGrowth)
summary(dat.ToothGrowth)

# Unload library
lib_unload(dat)

# Examine workspace again
ls()
# [1] "dat" "tmp"

# Clean up
lib_delete(dat)
}
\seealso{
\code{\link{lib_load}} to load the library.

Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_export}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
